function read_dat(ens::String, g1::String="G5", g2::String="G5")
    path = joinpath(path_data, ens)
    rep = readdir(path, join=true)
    aux = read_mesons.(rep, g1, g2)
    res = []
    for j =1:length(aux[1])
        aux2 = [aux[i][j] for i =1:length(aux)]
        push!(res, aux2)
    end
    return res
end
function get_mu(mu_list::Vector{Vector{Float64}}, deg::Bool)
    mu_sorted = unique(sort(minimum.(mu_list)))

    mul = mu_sorted[1]
    deg ? mus = 0.0 : mus = mu_sorted[2]
    muh = unique(maximum.(mu_list))
    muh = filter(x-> x > mul && x > mus, muh)

    return mul, mus, muh
end
function get_lh(mu_list, obs::Array{juobs.Corr}, deg::Bool)
    mul, mus, muh = get_mu(mu_list, deg)
    obs_lh = Array{juobs.Corr}(undef, 0)
    for k = 1:length(mu_list)
        mu = mu_list[k]
        if mul in mu && mu[1] != mu[2] && !(mus in mu) #l-h
            push!(obs_lh, obs[k])
        end
    end
    return obs_lh
end
function get_lh(mu_list, obs::Vector{Vector{juobs.Corr}}, deg::Bool)
    mul, mus, muh = get_mu(mu_list, deg)
    obs_lh = Array{Array{juobs.Corr}}(undef, length(obs), length(muh))
    for n_obs = 1:length(obs)
        obs_lh[n_obs] = get_lh(mu_list, obs[n_obs], deg)
    end
    return obs_lh
end
function get_sh(mu_list, obs::Array{juobs.Corr}, deg::Bool)
    mul, mus, muh = get_mu(mu_list, deg)
    obs_sh = Array{juobs.Corr}(undef, 0)
    for k = 1:length(mu_list)
        mu = mu_list[k]
        if mus in mu && mu[1] != mu[2] && !(mul in mu)#s-h
            push!(obs_sh, obs[k])
        end
    end
    return obs_sh
end
function get_sh(mu_list, obs::Vector{Vector{juobs.Corr}}, deg::Bool)
    mul, mus, muh = get_mu(mu_list, deg)
    obs_sh = Array{Array{juobs.Corr}}(undef, length(obs), length(muh))
    for n_obs = 1:length(obs)
        obs_sh[n_obs] = get_sh(mu_list, obs[n_obs], deg)
    end
    return obs_sh
end
function get_hh(mu_list, obs::Array{juobs.Corr}, deg::Bool)
    mul, mus, muh = get_mu(mu_list, deg)
    obs_hh = Array{juobs.Corr}(undef,0)
    for k = 1:length(mu_list)
        mu = mu_list[k]
        for i =1:length(muh)
            if muh[i] in mu && mu[1] == mu[2]#h-h
                push!(obs_hh, obs[k])
            end
        end
    end
    return obs_hh
end
function get_hh(mu_list, obs::Vector{Vector{juobs.Corr}}, deg::Bool)
    mul, mus, muh = get_mu(mu_list, deg)
    obs_hh = Array{Array{juobs.Corr}}(undef, length(obs), length(muh))
    for n_obs = 1:length(obs)
        obs_hh[n_obs] = get_hh(mu_list, obs[n_obs], deg)
    end
    return obs_hh
end
mutable struct  infoMatt
    mat::Vector{Matrix}
    mu::Vector{Float64}
    y0::Int64
    function infoMatt(a11::Array{juobs.Corr}, a12::Array{juobs.Corr}, a22::Array{juobs.Corr})
        mu = getfield(a11[1], :mu)
        y0 = Int64(getfield(a11[1], :y0))
        elem11 = (sum(a11[i].obs for i =1:length(a11)))
        elem12 = (sum(a12[i].obs for i =1:length(a12)))
        elem22 = (sum(a22[i].obs for i =1:length(a22)))
        diag = [elem11, elem22]
        subdiag =[ elem12 ]
        #diag = [a11.obs, a22[1].obs.+a22[2].obs.+a22[3].obs]
        #subdiag = [a12[1].obs.+a12[2].obs.+a12[3].obs]
        mat = get_matrix(diag, subdiag)
        return new(mat, mu, y0)
    end
end
function comp_mat(tot11::Array{Array{juobs.Corr}}, tot12::Array{Array{juobs.Corr}}, tot22::Array{Array{juobs.Corr}})
    mu = getfield.(tot11[1],:mu)
    res = Array{infoMatt}(undef, length(mu))
    for i = 1:length(mu)
        a11 = [ tot11[j][i] for j = 1:size(tot11,1) ]
        a12 = [ tot12[j][i] for j = 1:size(tot12,1) ]
        a22 = [ tot22[j][i] for j = 1:size(tot22,1) ]
        res[i] = infoMatt(a11, a12, a22)
        #res[i]=  infoMatt(tot11[i], [tot12[1][i],tot12[2][i],tot12[3][i]], [tot22[1][i],tot22[2][i],tot22[3][i]])
    end
    return res
end
function comp_mat(tot11::Array{Array{juobs.Corr}}, tot12::Array{Array{juobs.Corr}}, tot13::Array{Array{juobs.Corr}}, tot22::Array{Array{juobs.Corr}}, tot33::Array{Array{juobs.Corr}}, tot23::Array{Array{juobs.Corr}})
    mu = getfield.(tot11[1],:mu)
    res = Array{infoMatt}(undef, length(mu))
    for i = 1:length(mu)
        a11 = [ tot11[j][i] for j = 1:size(tot11,1) ]
        a12 = [ tot12[j][i] for j = 1:size(tot12,1) ]
        a22 = [ tot22[j][i] for j = 1:size(tot22,1) ]
        a33 = [ tot33[j][i] for j = 1:size(tot33,1) ]
        a13 = [ tot13[j][i] for j = 1:size(tot13,1) ]
        a23 = [ tot23[j][i] for j = 1:size(tot23,1) ]
        res[i] = infoMatt(a11, a12, a13, a22, a23, a33)
        #res[i]=  infoMatt(tot11[i], [tot12[1][i],tot12[2][i],tot12[3][i]], [tot22[1][i],tot22[2][i],tot22[3][i]])
    end
    return res
end
function comp_energy(tot11::Array{Array{juobs.Corr}}, tot12::Array{Array{juobs.Corr}}, tot22::Array{Array{juobs.Corr}}, evec::Bool=false; tnot::Int64=3)
    aux_mat = comp_mat(tot11, tot12, tot22)
    y0 = getfield(aux_mat[1], :y0)
    res_en = Array{infoEn}(undef, length(aux_mat))
    if !evec
        for i = 1:length(aux_mat)
            mat_obs = getfield(aux_mat[i], :mat)[y0+1:end-1]
            evalues = uwgevp_tot(mat_obs, tnot)
            res_en[i] = infoEn(energies(evalues), aux_mat[i])
        end
        return res_en
    else
        evec = Array{Array{}}(undef, length(aux_mat))
        for i = 1:length(aux_mat)
            mat_obs = getfield(aux_mat[i], :mat)[y0+1:end-1]
            eigvec = uwgevp_tot(mat_obs, delta_t=3)
            #res_en[i] = infoEn(energies(evalues), aux_mat[i])
            evec[i] = eigvec
        end
        return  evec
    end
end
function comp_energy(tot11::Array{Array{juobs.Corr}}, tot12::Array{Array{juobs.Corr}}, tot13::Array{Array{juobs.Corr}}, tot22::Array{Array{juobs.Corr}}, tot33::Array{Array{juobs.Corr}}, tot23::Array{Array{juobs.Corr}}, evec::Bool=false; tnot::Int64=2)
    aux_mat = comp_mat(tot11, tot12, tot13, tot22, tot23, tot33)
    y0 = getfield(aux_mat[1], :y0)
    res_en = Array{infoEn}(undef, length(aux_mat))
    if !evec
        for i = 1:length(aux_mat)
            mat_obs = getfield(aux_mat[i], :mat)[y0+1:end-1]
            evalues = uwgevp_tot(mat_obs, tnot, iter=50)
            res_en[i] = infoEn(energies(evalues), aux_mat[i])
        end
        return res_en
    else
        evec = Array{Array{}}(undef, length(aux_mat))
        for i = 1:length(aux_mat)
            mat_obs = getfield(aux_mat[i], :mat)[y0+1:end-1]
            eigvec = uwgevp_tot(mat_obs, delta_t=3)
            println("in comp_energy, i is = ", i)
            #res_en[i] = infoEn(energies(evalues), aux_mat[i])
            evec[i] = eigvec
        end
        return  evec
    end
end
mutable struct infoEn
    en_val::Array{Array{uwreal}}
    mu::Vector{Float64}
    y0::Int64
    function infoEn(energ::Array{Array{uwreal}},matr::infoMatt )
        en_val = energ
        mu = getfield(matr,:mu)
        y0 = getfield(matr,:y0)
        new(en_val, mu, y0)
    end
end
function pseudo_mat_elem(evec::Array{Array{T,2} where T,1}, mass::uwreal, mu::Array{Float64})
    Rn = [exp(mass * (t)/2) * evec[t][1] for t =1:length(evec)]
    aux = sqrt(2)*sum(mu)  / mass^1.5 
    return uwdot(aux,Rn)
end
function vec_mat_elem(evec::Array{Array{T,2} where T,1}, mass::uwreal, deg::Bool)
    if !deg
        Rn = [exp(mass * t/2) * evec[t][1] for t =1:length(evec)]
        return uwdot(Rn , za(beta[iens]) * sqrt(2/ mass))
    else
        Rn = [exp(mass * t/2) * evec[t][4] for t =1:length(evec)]
        println(za(beta[iens]))
        println(mass)
        return uwdot(Rn , za(beta[iens]) * sqrt(2/ mass))
        #return uwdot(Rn , 1/mass)# * sqrt(2/ mass))
end

end
function extract_dec_const(mat_elem::uwreal, mass::uwreal, mu::Array{Float64})
    return sqrt(2)*sum(mu)*mat_elem / mass^1.5
end
function match_muc(muh, m_lh, m_lh_star, target)
    M = (m_lh .+ 3 .* m_lh_star) ./ 4

    par, chi2exp = lin_fit(muh, M)
    muh_target = x_lin_fit(par, target)
    return muh_target
end
function match_muc(muh, m_lh, m_sh, m_lh_star, m_sh_star, target)
    M = (2 .* m_lh .+ 6 .* m_lh_star .+ m_sh .+ 3 .* m_sh_star) ./ 12

    par, chi2exp = lin_fit(muh, M)
    muh_target = x_lin_fit(par, target)
    return muh_target
end